@extends('admin.layout.template')
@section('title', 'Edit Role')
<style>
    .border {
        box-shadow: rgba(0, 0, 0, 0.1) 0px 4px 12px;
    }
</style>
@section('content')
<div class="page-content">
    <div class="container-xxl">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0 py-0">
                <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{route('roles.index')}}">Roles</a></li>
                <li class="breadcrumb-item active" aria-current="page">Edit Roles</li>
            </ol>
        </nav>
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Edit Role</h4>
            </div>

            <form id="editRoleForm">
                @csrf
                @method('PUT')

                <div class="card-body">
   <div class="row">
                    <!-- Role Name -->
                    <div class="mb-4 col-md-6">
                        <label class="form-label">Role Name</label>
                        <input type="text"
                            name="role_name"
                            class="form-control"
                            value="{{ $role->name }}"
                            required>
                    </div>
<div class="mb-3 col-md-6">
    <label class="form-label">Departments</label>
    <select name="department_ids[]" class="form-select" data-choices multiple>
        @foreach($departments as $department)
            <option value="{{ $department->id }}"
                {{ in_array($department->id, $selectedDepartments) ? 'selected' : '' }}>
                {{ $department->name }}
            </option>
        @endforeach
    </select>
</div>

                    </div>
                    <hr>

                    <!-- Permissions -->
                    @foreach($permissions as $module => $perms)
                    <div class="border rounded p-3 mb-3">

                        {{-- Module Header --}}
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <h5 class="mb-0 text-capitalize">{{ str_replace(['-', '_'], ' ', $module) }}</h5>

                            <div>
                                <input type="checkbox"
                                    class="form-check-input select-all"
                                    data-module="{{ $module }}">
                                <label class="form-check-label">Select All</label>
                            </div>
                        </div>

                        {{-- Permissions Checkboxes --}}
                        <div class="row">
                            @foreach($perms as $permission)
                            <div class="col-md-3">
                                <div class="form-check mb-3">
                                    <input type="checkbox"
                                        class="form-check-input permission-checkbox module-{{ $module }}"
                                        name="permissions[]"
                                        value="{{ $permission }}"
                                        {{ in_array($permission, $rolePermissions) ? 'checked' : '' }}>

                                    <label class="form-check-label">
                                        {{ ucwords(str_replace(['.', '-'], ' ', $permission)) }}
                                    </label>
                                </div>
                            </div>
                            @endforeach
                        </div>
<hr>
<div class="row">
    <div class="mt-3 col-md-6">
        <label class="form-label">Data Access Scope</label>

        <select name="scopes[{{ $module }}][scope_type]"
            class="form-select scope-type"
            data-module="{{ $module }}">

            @php
            $selectedScope = $roleScopes[$module]['scope_type'] ?? 'all';
            @endphp

            <option value="all" {{ $selectedScope == 'all' ? 'selected' : '' }}>
                All Data
            </option>
            <option value="assigned_location" {{ $selectedScope == 'assigned_location' ? 'selected' : '' }}>
                Assigned Locations
            </option>
            <option value="assigned_franchise" {{ $selectedScope == 'assigned_franchise' ? 'selected' : '' }}>
                Assigned Franchise
            </option>
            <option value="assigned_dealer" {{ $selectedScope == 'assigned_dealer' ? 'selected' : '' }}>
                Assigned Dealer
            </option>
            <option value="assigned_projects" {{ $selectedScope == 'assigned_projects' ? 'selected' : '' }}>
                Assigned Projects
            </option>
            <option value="own_only" {{ $selectedScope == 'own_only' ? 'selected' : '' }}>
                Own Records Only
            </option>
        </select>
    </div>
    @php
    $scopeValues = $roleScopes[$module]['scope_value'] ?? [];
    @endphp

    <div class="mt-3 col-md-6 scope-value
    {{ $selectedScope == 'assigned_location' ? '' : 'd-none' }}"
        id="scope-assigned_location-{{ $module }}">

        <label class="form-label">Select Locations</label>

        <select name="scopes[{{ $module }}][scope_value][]"
            class="form-select" data-choices multiple>

            @foreach(App\Models\Location::get() as $location)
            <option value="{{ $location->id }}"
                {{ in_array($location->id, $scopeValues) ? 'selected' : '' }}>
                {{ $location->name }}
            </option>
            @endforeach
        </select>
    </div>

    <div class="mt-3 col-md-6 scope-value
    {{ $selectedScope == 'assigned_franchise' ? '' : 'd-none' }}"
        id="scope-assigned_franchise-{{ $module }}">

        <label class="form-label">Select Franchise</label>

        <select name="scopes[{{ $module }}][scope_value][]"
            class="form-select" data-choices multiple>

            @foreach(App\Models\User::where('user_type','franchise')->get() as $franchise)
            <option value="{{ $franchise->id }}"
                {{ in_array($franchise->id, $scopeValues) ? 'selected' : '' }}>
                {{ $franchise->name }}
            </option>
            @endforeach
        </select>
    </div>

    <div class="mt-3 col-md-6 scope-value
    {{ $selectedScope == 'assigned_dealer' ? '' : 'd-none' }}"
        id="scope-assigned_dealer-{{ $module }}">

        <label class="form-label">Select Dealers</label>

        <select name="scopes[{{ $module }}][scope_value][]"
            class="form-select" data-choices multiple>

            @foreach(App\Models\User::where('user_type','dealer')->get() as $dealer)
            <option value="{{ $dealer->id }}"
                {{ in_array($dealer->id, $scopeValues) ? 'selected' : '' }}>
                {{ $dealer->name }}
            </option>
            @endforeach
        </select>
    </div>

</div>
                    </div>
                    @endforeach
@php
    $isLocked = optional($role->dataScopes->first())->is_locked;
@endphp

@if(auth()->user()->hasRole('Super Admin'))
<div class="form-check mt-4">
    <input type="checkbox"
        class="form-check-input"
        name="is_locked"
        value="1"
        {{ $isLocked ? 'checked' : '' }}>

    <label class="form-check-label fw-semibold">
        Lock this role (System Role)
    </label>
</div>
@endif


                </div>

                <div class="card-footer text-end">
                    <button type="submit" class="btn btn-primary">
                        Update Role
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>

<script>
    /* Select All per module */
    document.querySelectorAll('.select-all').forEach(selectAll => {
        selectAll.addEventListener('change', function() {
            let module = this.dataset.module;
            document
                .querySelectorAll('.module-' + module)
                .forEach(cb => cb.checked = this.checked);
        });
    });

    /* Submit Edit */
    $('#editRoleForm').on('submit', function(e) {
        e.preventDefault();

        Swal.fire({
            title: 'Are you sure?',
            text: 'Do you want to update this role?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Yes, update it',
            cancelButtonText: 'Cancel'
        }).then((result) => {

            if (result.isConfirmed) {
                $.ajax({
                    url: "{{ route('roles.update', $role->id) }}",
                    type: 'POST',
                    data: $(this).serialize(),
                    success: function(res) {
                        if (res.status) {
                            Swal.fire('Updated!', res.message, 'success')
                                .then(() => {
                                    window.location.href = "{{ route('roles.index') }}";
                                });
                        } else {
                            Swal.fire('Error', res.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire(
                            'Error',
                            xhr.responseJSON?.message || 'Something went wrong',
                            'error'
                        );
                    }
                });
            }

        });
    });

document.querySelectorAll('.scope-type').forEach(select => {
    select.addEventListener('change', function () {
        let module = this.dataset.module;

        document.querySelectorAll(`[id^="scope-"][id$="-${module}"]`)
            .forEach(el => el.classList.add('d-none'));

        if (this.value !== 'all' && this.value !== 'own_only') {
            document
                .getElementById(`scope-${this.value}-${module}`)
                ?.classList.remove('d-none');
        }
    });
});
</script>


@endsection